using Plots, XLSX, DataFrames

σ = 0.07
β = 0.3
#China 11m, SK 52m, Italy 60m
N = 11000000

cd("/Users/urielyang/OneDrive - Emory University/Honors")
res = XLSX.readdata("Data.xlsx", "Sheet", "E2:F105")


infected = res[:, 1]
plot(infected, label="infected")
plot!(xlabel="days", ylabel="population")
recovered = res[:, 2]
plot!(recovered, label="recovered")

dI = diff(infected)
dR = diff(recovered)

plot(dI, label ="dI")
plot!(dR, label ="dR")

exposed = (dI + dR) / σ
plot(exposed, label="recovered exposed")
dE = diff(exposed)
plot(dE, label="recovered dE")


dS = - (dE .+ σ * exposed[2:end])
plot(dS, label="recovered dS")

S = zeros(size(dS)[1]+1, 1)

S[1] = N
for i in 2:size(S)[1]
    S[i] = S[i-1] + dS[i-1]
end
plot(S, label="recovered susceptible")

t = 15.0:1:100.0
combined_q = (dE + σ * exposed[2:end]) * N ./ (infected[3:end] .* S[2:end])
quarantine = β .- combined_q
plot(t, quarantine[15:100])

XLSX.openxlsx("recovered_WH.xlsx", mode="w") do xf
    sheet = xf[1]
    XLSX.rename!(sheet, "Data")
    sheet["A1", dim=1] = collect(quarantine)
end
